//Caption: Linear Convolution using Circular Convolution
//DFT-IDFT method
clc;
clear;
close;
x = input('Enter the input discrete sequence:=')
h = input('Enter the impulse discrete sequence:=')
N1 = length(x);
N2 = length(h);
N = N1+N2-1;//Linear Convolution result length
h = [h,zeros(1,N-N2)];
x = [x,zeros(1,N-N1)];
//Computing DFT-IDFT
XK = dft(x,-1);//N point DFT of i/p sequence
HK = dft(h,-1);//N point DFT of impulse sequence
//Multiplication of 2 DFT's
YK = XK.*HK;
//Linear Convolution result
yn = dft(YK,1);//IDFT of Y(K)(o/p sequence)
disp(real(yn),'Linear Convolution result y[n]:=') 
//Example
//Enter the input discrete sequence:= [1,2,3]
//Enter the impulse discrete sequence:=[1,2,2,1]
//Linear Convolution result y[n]:=   
// 
//    1.   
//    4.   
//    9.   
//    11.  
//    8.   
//    3. 
